# .NET 规范实现情况的查询

.NET Standard 是针对多个 .NET 实现推出的一套正式的 .NET API 规范。

请编写一段代码，支持功能：**查询支持某个 .NET Standard 版本的所有.NET 实现的最低版本**。

执行运行命令`dotnet new console --output StandardQuery`创建测试项目，添加测试代码如下：

```csharp
// 下面的C#列表，表示.NET Standard的版本号列表
var dotnetStandard = new List<string>(){
    "1.0", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "2.0", "2.1"
};

// 而下面的C#字典，表示了.NET 每种实现支持上述对应.NET Standard 规范的最低版本：
var dotnetImplements = new Dictionary<string, List<string>>(){
    [".NET 和.NET Core"]=new List<string>(){"1.0", "1.0", "1.0", "1.0", "1.0", "1.0", "1.0", "2.0", "3.0"},
    [".NET Framework"]=new List<string>(){"1", "4.5", "4.5", "4.5.1", "4.6", "4.6.1", "4.6.1^2", "4.6.1", "2", "4.6.1^2", "N/A3"},
    ["Mono"]=new List<string>(){"4.6", "4.6", "4.6", "4.6", "4.6", "4.6", "4.6", "5.4", "6.4"},
    ["Xamarin.iOS"]=new List<string>(){"10.0", "10.0", "10.0", "10.0", "10.0", "10.0", "10.0", "10.14", "12.16"},
    ["Xamarin.Mac"]=new List<string>(){"3.0", "3.0", "3.0", "3.0", "3.0", "3.0", "3.0", "3.8", "5.16"},
    ["Xamarin.Android"]=new List<string>(){"7.0", "7.0", "7.0", "7.0", "7.0", "7.0", "7.0", "8.0", "10.0"},
    ["通用 Windows 平台"]=new List<string>(){"10.0", "10.0", "10.0", "10.0", "10.0", "10.0.16299", "10.0.16299", "10.0.16299", "待定"},
    ["Unity"]=new List<string>(){"2018/1", "2018/1", "2018/1", "2018/1", "2018/1", "2018/1", "2018/1", "2018/1", "2021.2"}
};

var dotnetStandardQuery = new Dictionary<string, List<string>>();

//TODO(You): 请在此实现代码

Console.WriteLine("以下各种.NET的实现，支持了 .NET Standard 2.1的最低版本是：");
Console.WriteLine("====");
foreach(var lowlowerSupportImplementVersion in dotnetStandardQuery["2.1"]){
    Console.WriteLine("* "+lowlowerSupportImplementVersion);
}
```

执行运行命令`dotnet run --project StandardQuery` 后输出：

```bash
以下各种.NET的实现，支持了 .NET Standard 2.1的最低版本是：
====
* .NET 和.NET Core，版本：3.0
* .NET Framework，版本：2
* Mono，版本：6.4
* Xamarin.iOS，版本：12.16
* Xamarin.Mac，版本：5.16
* Xamarin.Android，版本：10.0
* 通用 Windows 平台，版本：待定
* Unity，版本：2021.2
```

以下正确的实现代码是？

## 答案

```csharp
int i=0;
foreach(var standardVersion in dotnetStandard){
    var lowerSupportImplementVersions = new List<String>();
    foreach(var dotnetImplement in dotnetImplements){
        lowerSupportImplementVersions.Add(dotnetImplement.Key+"，版本："+dotnetImplement.Value[i]);
    }
    dotnetStandardQuery.Add(standardVersion, lowerSupportImplementVersions);
    i++;
}
```

## 选项

### 取值不对

```csharp
int i=0;
foreach(var standardVersion in dotnetStandard){
    var lowerSupportImplementVersions = new List<String>();
    foreach(var dotnetImplement in dotnetImplements){
        lowerSupportImplementVersions.Add(dotnetImplement.Key+"，版本："+dotnetImplement);
    }
    dotnetStandardQuery.Add(standardVersion, lowerSupportImplementVersions);
    i++;
}
```

### 少了分号

```cshapp
int i=0
foreach(var standardVersion in dotnetStandard){
    var lowerSupportImplementVersions = new List<String>()
    foreach(var dotnetImplement in dotnetImplements){
        lowerSupportImplementVersions.Add(dotnetImplement.Key+"，版本："+dotnetImplement.Value[i])
    }
    dotnetStandardQuery.Add(standardVersion, lowerSupportImplementVersions)
    i++
}
```

### 列表初始化不对

```csharp
int i=0;
foreach(var standardVersion in dotnetStandard){
    var lowerSupportImplementVersions = [];
    foreach(var dotnetImplement in dotnetImplements){
        lowerSupportImplementVersions.Add(dotnetImplement.Key+"，版本："+dotnetImplement.Value[i]);
    }
    dotnetStandardQuery.Add(standardVersion, lowerSupportImplementVersions);
    i++;
}
```
